function getTrackXHRBG(attr) {
    return new Promise((resolve, reject) => {
        var ordernumber = attr.ordernumber, refresh = attr.refresh, inLS = DATA.tracks[ordernumber];
        if (inLS && !refresh) return resolve(inLS);
        var xhr = new XMLHttpRequest();
        xhr.open("GET", "https://track.aliexpress.com/logisticsdetail.htm?tradeId=" + ordernumber);
        xhr.onload = (() => {
            var tracknumber = [];
            if (/"logisticsNo":"(.*?)"/.exec(xhr.responseText)) tracknumber.push(/"logisticsNo":"(.*?)"/.exec(xhr.responseText)[1]);
            if (/"interMailNo":"(.*?)"/.exec(xhr.responseText)) tracknumber.push(/"interMailNo":"(.*?)"/.exec(xhr.responseText)[1]);
            if (/"lgOrderCode":"(.*?)"/.exec(xhr.responseText)) tracknumber.push(/"lgOrderCode":"(.*?)"/.exec(xhr.responseText)[1]);
            if (/"realMailNo":"(.*?)"/.exec(xhr.responseText)) tracknumber.push(/"realMailNo":"(.*?)"/.exec(xhr.responseText)[1]);
            if (/"mailNo":"(.*?)"/.exec(xhr.responseText)) tracknumber.push(/"mailNo":"(.*?)"/.exec(xhr.responseText)[1]);
            if (tracknumber.length > 0) {
                tracknumber = removeDublicate(tracknumber);
                DATA.tracks[ordernumber] = tracknumber;
                saveDATA();
                return resolve(tracknumber);
            } else return resolve([]);
        });
        xhr.onerror = (error => {
            console.log(error);
            return reject("Ошибка получения страницы отслеживания");
        });
        xhr.send();
    });
}

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.hasOwnProperty("getTrack")) {
        getTrackXHRBG(request.getTrack).then(r => {
            sendResponse(r);
        }).catch(error => {
            sendResponse(error);
        });
        return !0;
    }
    return !1;
});

chrome.runtime.onInstalled.addListener(details => {
    if ("install" == details.reason) {
        if (!DATA.hasOwnProperty("setting")) DATA.setting = {
            oldDesign: !1,
            totalPrice: !0,
            breadcrumbs: !0,
            origTitle: !0,
            extSearch: !0,
            stopSlider: !0,
            tracks: !0,
            evaHide: !0,
            hideTopBannerHome: !0,
            searchWithoutLogin: !0,
            copyLinkPage: !0
        };
        if (!DATA.hasOwnProperty("extSetting")) DATA.extSetting = {
            timePrice: 500,
            timeSlider: 500,
            trackURL: "https://gdeposylka.ru/*"
        };
        if (!DATA.hasOwnProperty("tracks")) DATA.tracks = {};
        saveDATA();
    }
    if ("update" == details.reason) if (Number(details.previousVersion) <= 2) {
        DATA.setting.hideTopBannerHome = !0;
        DATA.setting.searchWithoutLogin = !0;
        DATA.setting.copyLinkPage = !0;
        saveDATA();
    }
});