function normaliseInt(str) {
    return parseFloat((str.match(REGEXP) && str.match(REGEXP)[0] || str.match(REGEXP2) && str.match(REGEXP2)[0] || 0).replace(/\s/, "").replace(",", "."));
}

function RunTotalPrise() {
    var price = document.querySelector('.product-price-value[itemprop="price"]');
    if (price && (price.textContent.match(REGEXP) || price.textContent.match(REGEXP2))) price = normaliseInt(price.textContent); else price = 0;
    var shippingPrice = document.querySelector(".product-shipping-price .bold");
    if (shippingPrice && (shippingPrice.textContent.match(REGEXP) || shippingPrice.textContent.match(REGEXP2))) shippingPrice = normaliseInt(shippingPrice.textContent); else shippingPrice = 0;
    if (price) {
        var INPUT_ = document.querySelector(".product-number-picker input").value;
        if (shippingPrice) return (price * INPUT_ + shippingPrice).toFixed(2); else return (price * INPUT_).toFixed(2);
    }
    return 0;
}

function ReloadTotalPrise() {
    TOTALPRICE = RunTotalPrise();
    document.querySelector(".USER_totalPrice").textContent = "Общая сумма: " + TOTALPRICE;
}

function gettrack(el, ordernumber, refresh) {
    return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
            getTrack: {
                ordernumber: ordernumber,
                refresh: refresh
            }
        }, r => {
            resolve([ el, r ]);
        });
    });
}

function randomColor(brightness) {
    function randomChannel(brightness) {
        var r = 255 - brightness, s = (0 | Math.random() * r + brightness).toString(16);
        return 1 == s.length ? "0" + s : s;
    }
    return "#" + randomChannel(brightness) + randomChannel(brightness) + randomChannel(brightness);
}

function insertTrack(el, track) {
    var thisBTN = el.closest(".order-item-wraper").querySelector(".order-action button");
    track.forEach(c => {
        var color = "transparent";
        document.querySelectorAll(".inproveTrack").forEach(ie => {
            if (ie.textContent == c) {
                if ("transparent" == color) color = randomColor(160);
                ie.style.backgroundColor = color;
            }
        });
        var nc = DATA.extSetting.trackURL.replace(/\*/, c);
        thisBTN.insertAdjacentHTML("afterend", `\n<a class="inproveTrack" href="${nc}" target="_blank" style="background:${color};">${c}</a>\n`);
    });
    var trackrefresh = document.createElement("span");
    trackrefresh.className = "trackrefresh";
    trackrefresh.textContent = "↺";
    trackrefresh.addEventListener("click", () => {
        el.closest(".order-item-wraper").querySelectorAll(".inproveTrack, .trackrefresh").forEach(r => {
            r.remove();
        });
        gettrack(el, el.textContent.trim(), !0).then(e => {
            insertTrack(e[0], e[1]);
            saveDATA();
        });
    });
    thisBTN.parentNode.insertBefore(trackrefresh, thisBTN.nextSibling);
}