var DATA = {};

if (window.NodeList && !NodeList.prototype.forEach) NodeList.prototype.forEach = function(callback, thisArg) {
    thisArg = thisArg || window;
    for (var i = 0; i < this.length; i++) callback.call(thisArg, this[i], i, this);
};

[ Element.prototype, Document.prototype, DocumentFragment.prototype ].forEach(function(item) {
    if (!item.hasOwnProperty("append")) Object.defineProperty(item, "append", {
        configurable: !0,
        enumerable: !0,
        writable: !0,
        value: function() {
            var argArr = Array.prototype.slice.call(arguments), docFrag = document.createDocumentFragment();
            argArr.forEach(function(argItem) {
                var isNode = argItem instanceof Node;
                docFrag.appendChild(isNode ? argItem : document.createTextNode(String(argItem)));
            });
            this.appendChild(docFrag);
        }
    });
});

function saveDATA(fn) {
    chrome.storage.local.set(DATA, () => {
        if (fn) fn();
    });
}

chrome.storage.local.get(result => {
    DATA = result;
    if ("function" == typeof load) load();
});

chrome.storage.onChanged.addListener(e => {
    chrome.storage.local.get(result => {
        DATA = result;
    });
});

function removeDublicate(tracknumber) {
    return tracknumber.filter((v, i) => tracknumber.indexOf(v) === i);
}